# Script to manually import adjustment-data via a barcode
# The barcode is printed on a sheet of paper which is provided together with
# the according module.
# Scope of modules:
# * Stacker
# * Flashlamp
# * PMT
# * USLum

import asyncio
import socket
import os
import time
import sys
import ast

from enum import IntEnum

from pylog.pylogger import PyLogger

from datetime import datetime

from py_pli.pylib import VUnits, Measurements, GlobalVar
from predefined_tasks.common.helper import send_to_gc, mini_initialize_instrument, report_path, write_header_to_report
from py_pli.pyexception import UrpcFirmwareException
from pylog.pylogger import PyLogger
from meas_services.instrument import InstrumentService
from virtualunits.vu_scan_table import BarcodeReaderIDs

import config_enum.scan_table_enum as scan_table_enum
import config_enum.platedoor_enum as pd_enum


plate_door = VUnits.instance.hal.plateDoor
scan_table = VUnits.instance.hal.scan_table
logger = PyLogger.logger


PATH, SCRIPT = os.path.split(__file__)
FUNC_NAME = sys._getframe().f_code.co_name
BASE_NAME = SCRIPT.split('.')[0]
ADJUSTMENT_PATH = '/home/pkiuser/.config/pyrunner/'

# Logging, Messages, Reports
logger = PyLogger.logger

async def import_adjustment(module_sn = '0815', flashlamp = 1, stacker = 0, pmt1 = 0, pmt2 = 0, uslum = 0 ):
    # print " please place the barcode above the VACANT Barcode inside of the measurement chamber"
    # read until barcode != VACANT
    # Exctract parameter out of the decoded string
    # ask the user to confirm transfer
    # Save the new parameters in the according .adj file
    if flashlamp == "1":
        module_name = "Flashlamp"
    if stacker == "1":
        module_name = "Stacker"
    if pmt1 == "1":
        module_name = "PMT1"
    if pmt2 == "1":
        module_name = "PMT2"
    report_file = report_path(f'{module_name}_SN{module_sn}_{FUNC_NAME}')
    msg = f'Import adjustment values for {module_name}, S/N: {module_sn}'  
    await send_to_gc(msg, False, False)
    await plate_door.Open()
    msg = f'Please place Sheet with Barcode above the VACANT Barcode inside of the measurement chamber'
    await send_to_gc(msg, False, False)
    bc = "VACANT"
    while bc == "VACANT":
        bc = await scan_table.ReadBarcode(BarcodeReaderIDs.BCRLeft, ignore_vacant=False, map_barcode=True)
    pass